/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.AbstractMatcherTest;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.hamcrest.core.IsEqual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsIterableContainingInOrderTest
extends AbstractMatcherTest {
    private final Matcher<Iterable<? extends WithValue>> contains123 = IsIterableContainingInOrder.contains((Matcher[])new Matcher[]{IsIterableContainingInOrderTest.value(1), IsIterableContainingInOrderTest.value(2), IsIterableContainingInOrderTest.value(3)});

    @Override
    protected Matcher<?> createMatcher() {
        return IsIterableContainingInOrder.contains((Object[])new Integer[]{1, 2});
    }

    public void testMatchingSingleItemIterable() throws Exception {
        IsIterableContainingInOrderTest.assertMatches("Single item iterable", IsIterableContainingInOrder.contains((Object[])new Integer[]{1}), Arrays.asList(1));
    }

    public void testMatchingMultipleItemIterable() throws Exception {
        IsIterableContainingInOrderTest.assertMatches("Multiple item iterable", IsIterableContainingInOrder.contains((Object[])new Integer[]{1, 2, 3}), Arrays.asList(1, 2, 3));
    }

    public void testDoesNotMatchWithMoreElementsThanExpected() throws Exception {
        IsIterableContainingInOrderTest.assertMismatchDescription("Not matched: <4>", IsIterableContainingInOrder.contains((Object[])new Integer[]{1, 2, 3}), Arrays.asList(1, 2, 3, 4));
    }

    public void testDoesNotMatchWithFewerElementsThanExpected() throws Exception {
        List<WithValue> valueList = Arrays.asList(IsIterableContainingInOrderTest.make(1), IsIterableContainingInOrderTest.make(2));
        IsIterableContainingInOrderTest.assertMismatchDescription("No item matched: value with <3>", this.contains123, valueList);
    }

    public void testDoesNotMatchIfSingleItemMismatches() throws Exception {
        IsIterableContainingInOrderTest.assertMismatchDescription("item 0: value was <3>", IsIterableContainingInOrder.contains(IsIterableContainingInOrderTest.value(4)), Arrays.asList(IsIterableContainingInOrderTest.make(3)));
    }

    public void testDoesNotMatchIfOneOfMultipleItemsMismatch() throws Exception {
        IsIterableContainingInOrderTest.assertMismatchDescription("item 2: value was <4>", this.contains123, Arrays.asList(IsIterableContainingInOrderTest.make(1), IsIterableContainingInOrderTest.make(2), IsIterableContainingInOrderTest.make(4)));
    }

    public void testDoesNotMatchEmptyIterable() throws Exception {
        IsIterableContainingInOrderTest.assertMismatchDescription("No item matched: value with <4>", IsIterableContainingInOrder.contains(IsIterableContainingInOrderTest.value(4)), new ArrayList());
    }

    public void testHasAReadableDescription() {
        IsIterableContainingInOrderTest.assertDescription("iterable containing [<1>, <2>]", IsIterableContainingInOrder.contains((Object[])new Integer[]{1, 2}));
    }

    public static WithValue make(int value) {
        return new WithValue(value);
    }

    public static Matcher<WithValue> value(int value) {
        return new FeatureMatcher<WithValue, Integer>(IsEqual.equalTo((Object)value), "value with", "value"){

            protected Integer featureValueOf(WithValue actual) {
                return actual.getValue();
            }
        };
    }

    public static class WithValue {
        private final int value;

        public WithValue(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return "WithValue " + this.value;
        }
    }
}

